/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.repack.codechicken.lib.colour.Colour;
import cofh.repack.codechicken.lib.colour.ColourRGBA;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static final RenderItem renderItem;
    public static final RenderBlocks renderBlocks;
    public static float[][] angleBaseYNeg;
    public static float[][] angleBaseYPos;
    public static float[][] angleBaseXPos;
    public static final float factor = 0.0625f;
    public static final int[] facingAngle;
    public static ScaledIconTransformation[] renderTransformations;
    public static Vector3 renderVector;

    public static ScaledIconTransformation getIconTransformation(IIcon iIcon) {
        if (iIcon != null) {
            RenderUtils.renderTransformations[0].icon = iIcon;
        }
        return renderTransformations[0];
    }

    public static Vector3 getRenderVector(double d, double d2, double d3) {
        RenderUtils.renderVector.x = d;
        RenderUtils.renderVector.y = d2;
        RenderUtils.renderVector.z = d3;
        return renderVector;
    }

    public static int getFluidRenderColor(FluidStack fluidStack) {
        return fluidStack.getFluid().getColor(fluidStack);
    }

    public static void setFluidRenderColor(FluidStack fluidStack) {
        CCRenderState.baseColour = 0xFF | fluidStack.getFluid().getColor(fluidStack) << 8;
    }

    public static void preItemRender() {
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        CCRenderState.reset();
        CCRenderState.pullLightmap();
        CCRenderState.useNormals = true;
    }

    public static void postItemRender() {
        CCRenderState.useNormals = false;
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
    }

    public static void preWorldRender(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        CCRenderState.reset();
        CCRenderState.setColour(-1);
        CCRenderState.setBrightness(iBlockAccess, n, n2, n3);
    }

    public static void renderMask(IIcon iIcon, IIcon iIcon2, Colour colour, IItemRenderer.ItemRenderType itemRenderType) {
        if (iIcon == null || iIcon2 == null) {
            return;
        }
        if (colour == null) {
            colour = new ColourRGBA(-1);
        }
        colour.glColour();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        if (itemRenderType.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(iIcon, 10.0);
        } else {
            RenderUtils.preRenderIconWorld(iIcon, 0.001);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        if (itemRenderType.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(iIcon, -0.0635);
        } else {
            RenderUtils.preRenderIconWorld(iIcon, -0.0635);
        }
        tessellator.draw();
        RenderHelper.setBlockTextureSheet();
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        if (itemRenderType.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(iIcon2, 10.0);
        } else {
            RenderUtils.preRenderIconWorld(iIcon2, 0.001);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        if (itemRenderType.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(iIcon2, -0.0635);
        } else {
            RenderUtils.preRenderIconWorld(iIcon2, -0.0635);
        }
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void preRenderIconWorld(IIcon iIcon, double d) {
        Tessellator.instance.addVertexWithUV(0.0, 1.0, d, (double)iIcon.getMinU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(1.0, 1.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(1.0, 0.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMinV());
        Tessellator.instance.addVertexWithUV(0.0, 0.0, d, (double)iIcon.getMinU(), (double)iIcon.getMinV());
    }

    public static void preRenderIconInv(IIcon iIcon, double d) {
        Tessellator.instance.addVertexWithUV(0.0, 16.0, d, (double)iIcon.getMinU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 16.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 0.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMinV());
        Tessellator.instance.addVertexWithUV(0.0, 0.0, d, (double)iIcon.getMinU(), (double)iIcon.getMinV());
    }

    public static void renderItemStack(int n, int n2, float f, ItemStack itemStack, Minecraft minecraft) {
        if (itemStack != null) {
            float f2 = (float)itemStack.animationsToGo - f;
            if (f2 > 0.0f) {
                GL11.glPushMatrix();
                float f3 = 1.0f + f2 / 5.0f;
                GL11.glTranslatef((float)(n + 8), (float)(n2 + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / f3), (float)((f3 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(n + 8)), (float)(-(n2 + 12)), (float)0.0f);
            }
            renderItem.renderItemAndEffectIntoGUI(minecraft.fontRenderer, minecraft.renderEngine, itemStack, n, n2);
            if (f2 > 0.0f) {
                GL11.glPopMatrix();
            }
            renderItem.renderItemOverlayIntoGUI(minecraft.fontRenderer, minecraft.renderEngine, itemStack, n, n2);
        }
    }

    public static void renderItemStackAtScale(float f, float f2, float f3, ItemStack itemStack, Minecraft minecraft, float f4, boolean bl) {
        if (itemStack != null) {
            if (!bl) {
                itemStack = itemStack.copy();
                itemStack.stackSize = 1;
            }
            float f5 = (float)itemStack.animationsToGo - f3;
            RenderUtils.renderItem.zLevel = 500.0f;
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            if (f5 > 0.0f) {
                float f6 = f4 + f5 / 5.0f;
                GL11.glTranslatef((float)(f + 8.0f), (float)(f2 + 12.0f), (float)0.0f);
                GL11.glScalef((float)(f4 / f6), (float)((f6 + f4) / 2.0f), (float)f4);
                GL11.glTranslatef((float)(-(f + 8.0f)), (float)(-(f2 + 12.0f)), (float)0.0f);
            } else {
                GL11.glScalef((float)f4, (float)f4, (float)f4);
            }
            RenderUtils.renderItemAndEffectIntoGUI(minecraft.fontRenderer, minecraft.renderEngine, itemStack, f, f2);
            renderItem.renderItemOverlayIntoGUI(minecraft.fontRenderer, minecraft.renderEngine, itemStack, (int)f, (int)f2);
            GL11.glPopMatrix();
            RenderUtils.renderItem.zLevel = 0.0f;
        }
    }

    public static void renderItemAndEffectIntoGUI(FontRenderer fontRenderer, TextureManager textureManager, ItemStack itemStack, float f, float f2) {
        if (itemStack != null && !ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)textureManager, (ItemStack)itemStack, (boolean)RenderUtils.renderItem.renderWithColor, (float)RenderUtils.renderItem.zLevel, (float)f, (float)f2)) {
            RenderUtils.renderItemIntoGUI(fontRenderer, textureManager, itemStack, f, f2, true);
        }
    }

    public static void renderItemIntoGUI(FontRenderer fontRenderer, TextureManager textureManager, ItemStack itemStack, float f, float f2, boolean bl) {
        Item item = itemStack.getItem();
        int n = itemStack.getItemDamage();
        IIcon iIcon = itemStack.getIconIndex();
        Block block = Block.getBlockFromItem((Item)item);
        if (itemStack.getItemSpriteNumber() == 0 && block != null && RenderBlocks.renderItemIn3d((int)block.getRenderType())) {
            textureManager.bindTexture(TextureMap.locationBlocksTexture);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(f - 2.0f), (float)(f2 + 3.0f), (float)(-3.0f + RenderUtils.renderItem.zLevel));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (RenderUtils.renderItem.renderWithColor) {
                int n2 = item.getColorFromItemStack(itemStack, 0);
                float f3 = (float)(n2 >> 16 & 0xFF) / 255.0f;
                float f4 = (float)(n2 >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(n2 & 0xFF) / 255.0f;
                GL11.glColor4f((float)f3, (float)f4, (float)f5, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderUtils.renderBlocks.useInventoryTint = RenderUtils.renderItem.renderWithColor;
            renderBlocks.renderBlockAsItem(block, n, 1.0f);
            RenderUtils.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
        } else if (item.requiresMultipleRenderPasses()) {
            GL11.glDisable((int)2896);
            ResourceLocation resourceLocation = itemStack.getItemSpriteNumber() == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture;
            textureManager.bindTexture(resourceLocation);
            int n3 = item.getRenderPasses(n);
            for (int i = 0; i < n3; ++i) {
                iIcon = item.getIcon(itemStack, i);
                if (RenderUtils.renderItem.renderWithColor) {
                    int n4 = item.getColorFromItemStack(itemStack, i);
                    float f6 = (float)(n4 >> 16 & 0xFF) / 255.0f;
                    float f7 = (float)(n4 >> 8 & 0xFF) / 255.0f;
                    float f8 = (float)(n4 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f6, (float)f7, (float)f8, (float)1.0f);
                }
                RenderHelper.renderIcon(f, f2, RenderUtils.renderItem.zLevel, iIcon, 16, 16);
                if (!itemStack.hasEffect(i)) continue;
                RenderUtils.renderEffect(textureManager, f, f2);
                textureManager.bindTexture(resourceLocation);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
            ResourceLocation resourceLocation = textureManager.getResourceLocation(itemStack.getItemSpriteNumber());
            textureManager.bindTexture(resourceLocation);
            if (iIcon == null) {
                iIcon = ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(resourceLocation)).getAtlasSprite("missingno");
            }
            if (RenderUtils.renderItem.renderWithColor) {
                int n5 = item.getColorFromItemStack(itemStack, 0);
                float f9 = (float)(n5 >> 16 & 0xFF) / 255.0f;
                float f10 = (float)(n5 >> 8 & 0xFF) / 255.0f;
                float f11 = (float)(n5 & 0xFF) / 255.0f;
                GL11.glColor4f((float)f9, (float)f10, (float)f11, (float)1.0f);
            }
            RenderHelper.renderIcon(f, f2, RenderUtils.renderItem.zLevel, iIcon, 16, 16);
            GL11.glEnable((int)2896);
            if (itemStack.hasEffect(0)) {
                RenderUtils.renderEffect(textureManager, f, f2);
            }
        }
        GL11.glEnable((int)2884);
    }

    public static void renderEffect(TextureManager textureManager, float f, float f2) {
        GL11.glDepthFunc((int)516);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        textureManager.bindTexture(RenderHelper.MC_ITEM_GLINT);
        RenderUtils.renderItem.zLevel -= 50.0f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)774, (int)774);
        GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
        RenderUtils.renderGlint(f - 2.0f, f2 - 2.0f, 20, 20);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        RenderUtils.renderItem.zLevel += 50.0f;
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }

    public static void renderGlint(float f, float f2, int n, int n2) {
        Tessellator tessellator = RenderHelper.tessellator();
        float f3 = 0.00390625f;
        float f4 = 0.00390625f;
        float f5 = 4.0f;
        GL11.glBlendFunc((int)768, (int)1);
        for (int i = 0; i < 2; ++i) {
            float f6 = (float)(Minecraft.getSystemTime() % (long)(3000 + i * 1873)) / (3000.0f + (float)(i * 1873)) * 256.0f;
            float f7 = 0.0f;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV((double)(f + 0.0f), (double)(f2 + (float)n2), (double)RenderUtils.renderItem.zLevel, (double)((f6 + 0.0f + (float)n2 * f5) * f3), (double)((f7 + (float)n2) * f4));
            tessellator.addVertexWithUV((double)(f + (float)n), (double)(f2 + (float)n2), (double)RenderUtils.renderItem.zLevel, (double)((f6 + (float)n + (float)n2 * f5) * f3), (double)((f7 + (float)n2) * f4));
            tessellator.addVertexWithUV((double)(f + (float)n), (double)(f2 + 0.0f), (double)RenderUtils.renderItem.zLevel, (double)((f6 + (float)n + 0.0f) * f3), (double)((f7 + 0.0f) * f4));
            tessellator.addVertexWithUV((double)(f + 0.0f), (double)(f2 + 0.0f), (double)RenderUtils.renderItem.zLevel, (double)((f6 + 0.0f + 0.0f) * f3), (double)((f7 + 0.0f) * f4));
            tessellator.draw();
            f5 = -1.0f;
        }
    }

    public static final void renderItemOnBlockSide(TileEntity tileEntity, ItemStack itemStack, int n, double d, double d2, double d3) {
        if (itemStack == null) {
            return;
        }
        GL11.glPushMatrix();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                GL11.glTranslated((double)(d + 0.75), (double)(d2 + 0.875), (double)(d3 - 9.765625E-4));
                break;
            }
            case 3: {
                GL11.glTranslated((double)(d + 0.25), (double)(d2 + 0.875), (double)(d3 + 1.0 + 9.765625E-4));
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 4: {
                GL11.glTranslated((double)(d - 9.765625E-4), (double)(d2 + 0.875), (double)(d3 + 0.25));
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 5: {
                GL11.glTranslated((double)(d + 1.0 + 9.765625E-4), (double)(d2 + 0.875), (double)(d3 + 0.75));
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
        }
        GL11.glScaled((double)0.03125, (double)0.03125, (double)-9.765625E-4);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        RenderUtils.setupLight(tileEntity, n);
        RenderHelper.enableGUIStandardItemLighting();
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)RenderHelper.engine(), (ItemStack)itemStack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
            renderItem.renderItemIntoGUI(Minecraft.getMinecraft().fontRenderer, RenderHelper.engine(), itemStack, 0, 0);
        }
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glPopMatrix();
        net.minecraft.client.renderer.RenderHelper.enableStandardItemLighting();
    }

    public static void setupLight(TileEntity tileEntity, int n) {
        if (tileEntity == null) {
            return;
        }
        int n2 = tileEntity.xCoord + BlockHelper.SIDE_COORD_MOD[n][0];
        int n3 = tileEntity.yCoord + BlockHelper.SIDE_COORD_MOD[n][1];
        int n4 = tileEntity.zCoord + BlockHelper.SIDE_COORD_MOD[n][2];
        World world = tileEntity.getWorldObj();
        if (world.getBlock(n2, n3, n4).isOpaqueCube()) {
            return;
        }
        int n5 = world.getLightBrightnessForSkyBlocks(n2, n3, n4, 4);
        int n6 = n5 & 0xFFFF;
        int n7 = n5 >>> 16;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)n6, (float)n7);
    }

    static {
        float f;
        renderItem = new RenderItem();
        renderBlocks = new RenderBlocks();
        angleBaseYNeg = new float[6][3];
        angleBaseYPos = new float[6][3];
        angleBaseXPos = new float[6][3];
        facingAngle = new int[]{0, 0, 180, 0, 90, -90};
        renderTransformations = new ScaledIconTransformation[4];
        RenderUtils.renderTransformations[0] = new ScaledIconTransformation(Blocks.stone.getIcon(0, 0));
        RenderUtils.renderTransformations[1] = new ScaledIconTransformation(Blocks.stone.getIcon(0, 0), -1.0, 0.0);
        RenderUtils.renderTransformations[2] = new ScaledIconTransformation(Blocks.stone.getIcon(0, 0), 0.0, -1.0);
        RenderUtils.renderTransformations[3] = new ScaledIconTransformation(Blocks.stone.getIcon(0, 0), -1.0, -1.0);
        renderVector = new Vector3();
        RenderUtils.angleBaseYNeg[0][2] = f = (float)Math.PI;
        RenderUtils.angleBaseYNeg[2][0] = -f / 2.0f;
        RenderUtils.angleBaseYNeg[3][0] = f / 2.0f;
        RenderUtils.angleBaseYNeg[4][2] = f / 2.0f;
        RenderUtils.angleBaseYNeg[5][2] = -f / 2.0f;
        RenderUtils.angleBaseYPos[1][2] = f;
        RenderUtils.angleBaseYPos[2][0] = f / 2.0f;
        RenderUtils.angleBaseYPos[3][0] = -f / 2.0f;
        RenderUtils.angleBaseYPos[4][2] = -f / 2.0f;
        RenderUtils.angleBaseYPos[5][2] = f / 2.0f;
        RenderUtils.angleBaseXPos[0][0] = -f / 2.0f;
        RenderUtils.angleBaseXPos[1][0] = f / 2.0f;
        RenderUtils.angleBaseXPos[2][1] = f;
        RenderUtils.angleBaseXPos[4][1] = -f / 2.0f;
        RenderUtils.angleBaseXPos[5][1] = f / 2.0f;
    }

    public static class ScaledIconTransformation
    extends IconTransformation {
        double su = 0.0;
        double sv = 0.0;

        public ScaledIconTransformation(IIcon iIcon) {
            super(iIcon);
        }

        public ScaledIconTransformation(IIcon iIcon, double d, double d2) {
            super(iIcon);
            this.su = d;
            this.sv = d2;
        }

        @Override
        public void apply(UV uV) {
            uV.u = (double)this.icon.getInterpolatedU(uV.u % 2.0 * 16.0) + this.su * (double)(this.icon.getMaxU() - this.icon.getMinU());
            uV.v = (double)this.icon.getInterpolatedV(uV.v % 2.0 * 16.0) + this.sv * (double)(this.icon.getMaxV() - this.icon.getMinV());
        }
    }
}

